CREATE TABLE IF NOT EXISTS databasemessagepool_usedpools (
  id INTEGER PRIMARY KEY AUTO_INCREMENT
);

CREATE TABLE IF NOT EXISTS databasemessagepool_sources (
  id                INTEGER PRIMARY KEY AUTO_INCREMENT,
  component_name    VARCHAR NOT NULL,
  subcomponent_name VARCHAR
);

CREATE TABLE IF NOT EXISTS databasemessagepool_messages (
  id          INTEGER PRIMARY KEY AUTO_INCREMENT,
  pool_id     INTEGER NOT NULL,
  source      INTEGER NOT NULL,
  message     VARCHAR NOT NULL,
  source_file VARCHAR,
  type        VARCHAR, CHECK (type IN ('message', 'warning', 'error')),
  lines       VARCHAR,
  FOREIGN KEY (pool_id) REFERENCES databasemessagepool_usedpools (id) ON DELETE CASCADE,
  FOREIGN KEY (source) REFERENCES databasemessagepool_sources (id) ON DELETE CASCADE,
);