CREATE TABLE IF NOT EXISTS articles (
  id                          INTEGER PRIMARY KEY AUTO_INCREMENT,
  artikelnummer               VARCHAR UNIQUE NOT NULL,
  barcode                     VARCHAR,
  bezeichnung1deutsch         VARCHAR,
  bezeichnung2deutsch         VARCHAR,
  preis1                      DECIMAL,
  preis2                      DECIMAL,
  preis3                      DECIMAL,
  preis4                      DECIMAL,
  preis1AbMenge               INTEGER,
  preis2AbMenge               INTEGER,
  preis3AbMenge               INTEGER,
  preis4AbMenge               INTEGER,
  aktionspreis                DECIMAL,
  aktionVonDatum              BIGINT,
  aktionBisDatum              BIGINT,
  lagerbestand                INTEGER,
  bestelldatum1               VARCHAR,
  bestellmenge1               INTEGER,
  bestelldatum2               VARCHAR,
  bestellmenge2               INTEGER,
  bestelldatum3               VARCHAR,
  bestellmenge3               INTEGER,
  rubrik                      VARCHAR        NOT NULL,
  warengruppe                 VARCHAR,
  artikelgruppe               VARCHAR,
/* serie wird in Tabelle articles_serien verwaltet */
  status                      INTEGER,
  CHECK (status IN (0, 1, 2, 3, 4, 5, 6)),
  statustext                  VARCHAR,
  ausfuehrung                 VARCHAR,
  verpackungseinheit          INTEGER,
  barcode2                    VARCHAR,
/*
 * aktionspreis2 sollte eigentlich DECIMAL
 * und lagerbestand 2 INTEGER > 0 sein.
 * Ggf. in Zukunft ändern und Daten migrieren
 */
  aktionspreis2               VARCHAR,
  lagerbestand2               VARCHAR,
  bezeichnung1englisch        VARCHAR,
  bezeichnung2englisch        VARCHAR,
  bezeichnung1franzoesisch    VARCHAR,
  bezeichnung2franzoesisch    VARCHAR,
  bezeichnung1niederlaendisch VARCHAR,
/*
 * bezeichnung2niederlaendisch und bezeichnung3 sind in Importdateien ein Feld,
 * hier aber getrennt. Der Importer soll das Trennen übernehmen.

 * SPEC: "'Bezeichnung 2 niederländisch' wird durch voranstellen von ## zur 'Artikelbezeichnung 3'"
 */
  bezeichnung2niederlaendisch VARCHAR,
  bezeichnung3                VARCHAR,
  kennzeichenTopseller        INTEGER,
  CHECK (kennzeichenTopseller IN (0, 1)),
  kennzeichenSonderangebot    INTEGER,
  CHECK (kennzeichenSonderangebot IN (0, 1)),
  kennzeichenNeuheit          INTEGER,
  CHECK (kennzeichenNeuheit IN (0, 1)),
  uvp                         DECIMAL,
  umverpackung                INTEGER,
  bezeichnung1spanisch        VARCHAR,
  bezeichnung2spanisch        VARCHAR,
  artikelkategorie4           VARCHAR,
/* stuecklistennummer(n) wird in Tabelle articles_stuecklistennummern verwaltet */
  stuecklisteJaNein           INTEGER,
  CHECK (stuecklisteJaNein IN (0, 1)),
  farbartikelJaNein           INTEGER,
  CHECK (farbartikelJaNein IN (0, 1)),
  gruppenkennzeichen          VARCHAR,
  artikelrabattgruppe         VARCHAR,
  artikelbild                 VARCHAR,
  farbnummer                  VARCHAR,
  groessennummer              VARCHAR,
  matrixkennzeichen           VARCHAR,
  artikelquerverweise         VARCHAR,
  lieferantenartikelnummer    VARCHAR,
  lieferantenname             VARCHAR,
  lieferantennummer           VARCHAR,
  last_modified               TIMESTAMP AS NOW()
);

CREATE INDEX IF NOT EXISTS articles_artikelnummer_index ON articles (artikelnummer);

CREATE TABLE IF NOT EXISTS articles_stuecklistennummern (
  id                 INTEGER PRIMARY KEY AUTO_INCREMENT,
  artikelnummer      VARCHAR NOT NULL,
  stuecklistennummer INTEGER,
  FOREIGN KEY (artikelnummer) REFERENCES articles (artikelnummer) ON DELETE CASCADE
);

CREATE TABLE IF NOT EXISTS articles_serien (
  id            INTEGER PRIMARY KEY AUTO_INCREMENT,
  artikelnummer VARCHAR NOT NULL,
  serie         VARCHAR,
  FOREIGN KEY (artikelnummer) REFERENCES articles (artikelnummer) ON DELETE CASCADE
);
CREATE TABLE IF NOT EXISTS volumeofsales (
  id            INTEGER PRIMARY KEY AUTO_INCREMENT,
  vertreter     VARCHAR,
  kundennummer  VARCHAR,
  periode       INTEGER,
  umsatz        DECIMAL,
  produktgruppe VARCHAR,
  gebaeckgruppe VARCHAR,
  jahr          INTEGER,
  monat         INTEGER,
  artikelnummer VARCHAR,
  last_modified TIMESTAMP AS NOW()
);