CREATE TABLE IF NOT EXISTS articles (
  id                          INTEGER PRIMARY KEY AUTO_INCREMENT,
  anzahlsemi                  INTEGER,
  artikelnummer               VARCHAR(199) UNIQUE NOT NULL,
  barcode                     VARCHAR(199),
  bezeichnung1deutsch         VARCHAR(199),
  bezeichnung2deutsch         VARCHAR(199),
  preis1                      DECIMAL(10,2),
  preis2                      DECIMAL(10,2),
  preis3                      DECIMAL(10,2),
  preis4                      DECIMAL(10,2),
  preis1AbMenge               INTEGER,
  preis2AbMenge               INTEGER,
  preis3AbMenge               INTEGER,
  preis4AbMenge               INTEGER,
  aktionspreis                DECIMAL(10,2),
  aktionVonDatum              BIGINT,
  aktionBisDatum              BIGINT,
  lagerbestand                INTEGER,
  bestelldatum1               VARCHAR(199),
  bestellmenge1               INTEGER,
  bestelldatum2               VARCHAR(199),
  bestellmenge2               INTEGER,
  bestelldatum3               VARCHAR(199),
  bestellmenge3               INTEGER,
  rubrik                      VARCHAR(199) NOT NULL,
  warengruppe                 VARCHAR(199),
  artikelgruppe               VARCHAR(199),
/* serie wird in Tabelle articles_serien verwaltet */
  status                      INTEGER, CONSTRAINT status CHECK (status IN (0, 1, 2, 3, 4, 5, 6)),
  statustext                  VARCHAR(199),
  ausfuehrung                 VARCHAR(199),
  verpackungseinheit          INTEGER,
  barcode2                    VARCHAR(199),
/*
 * aktionspreis2 sollte eigentlich DECIMAL
 * und lagerbestand 2 INTEGER > 0 sein.
 * Ggf. in Zukunft ändern und Daten migrieren
 */
  aktionspreis2               VARCHAR(199),
  lagerbestand2               VARCHAR(199),
  bezeichnung1englisch        VARCHAR(199),
  bezeichnung2englisch        VARCHAR(199),
  bezeichnung1franzoesisch    VARCHAR(199),
  bezeichnung2franzoesisch    VARCHAR(199),
  bezeichnung1niederlaendisch VARCHAR(199),
/*
 * bezeichnung2niederlaendisch und bezeichnung3 sind in Importdateien ein Feld,
 * hier aber getrennt. Der Importer soll das Trennen übernehmen.

 * SPEC: "'Bezeichnung 2 niederländisch' wird durch voranstellen von ## zur 'Artikelbezeichnung 3'"
 */
  bezeichnung2niederlaendisch VARCHAR(199),
  bezeichnung3                VARCHAR(199),
  kennzeichenTopseller        INTEGER, CONSTRAINT kennzeichenTopseller CHECK (kennzeichenTopseller IN (0, 1)),
  kennzeichenSonderangebot    INTEGER, CONSTRAINT kennzeichenSonderangebot CHECK (kennzeichenSonderangebot IN (0, 1)),
  kennzeichenNeuheit          INTEGER, CONSTRAINT kennzeichenNeuheit CHECK (kennzeichenNeuheit IN (0, 1)),
  uvp                         DECIMAL(10,2),
  umverpackung                INTEGER,
  bezeichnung1spanisch        VARCHAR(199),
  bezeichnung2spanisch        VARCHAR(199),
  artikelkategorie4           VARCHAR(199),
/* stuecklistennummer(n) wird in Tabelle articles_stuecklistennummern verwaltet */
  stuecklisteJaNein           INTEGER, CONSTRAINT stuecklisteJaNein CHECK (stuecklisteJaNein IN (0, 1)),
  farbartikelJaNein           INTEGER, CONSTRAINT farbartikelJaNein CHECK (farbartikelJaNein IN (0, 1)),
  gruppenkennzeichen          VARCHAR(199),
  artikelrabattgruppe         VARCHAR(199),
  artikelbild                 VARCHAR(199),
  farbnummer                  VARCHAR(199),
  groessennummer              VARCHAR(199),
  matrixkennzeichen           VARCHAR(199),
  artikelquerverweise         TEXT,
  lieferantenartikelnummer    VARCHAR(199),
  lieferantenname             VARCHAR(199),
  lieferantennummer           VARCHAR(199),
  last_modified               TIMESTAMP DEFAULT NOW() ON UPDATE CURRENT_TIMESTAMP,

    UNIQUE INDEX articles_artikelnummer_index (artikelnummer)
);

CREATE TABLE IF NOT EXISTS articles_stuecklistennummern (
  id                 INTEGER PRIMARY KEY AUTO_INCREMENT,
  artikelnummer      VARCHAR(199) NOT NULL,
  stuecklistennummer INTEGER,
  FOREIGN KEY (artikelnummer) REFERENCES articles (artikelnummer) ON DELETE CASCADE
);

CREATE TABLE IF NOT EXISTS articles_serien (
  id            INTEGER PRIMARY KEY AUTO_INCREMENT,
  artikelnummer VARCHAR(199) NOT NULL,
  serie         VARCHAR(199),
  FOREIGN KEY (artikelnummer) REFERENCES articles (artikelnummer) ON DELETE CASCADE
);
CREATE TABLE IF NOT EXISTS volumeofsales (
  id            INTEGER PRIMARY KEY AUTO_INCREMENT,
  vertreter     VARCHAR(199),
  kundennummer  VARCHAR(199),
  periode       INTEGER,
  umsatz        DECIMAL(10,2),
  produktgruppe VARCHAR(199),
  gebaeckgruppe VARCHAR(199),
  jahr          INTEGER,
  monat         INTEGER,
  artikelnummer VARCHAR(199),
  last_modified TIMESTAMP DEFAULT NOW()  ON UPDATE CURRENT_TIMESTAMP
);