CREATE TABLE IF NOT EXISTS customers (
  id                       INTEGER PRIMARY KEY AUTO_INCREMENT,
  kundennummer             VARCHAR(199),
  kundentyp                VARCHAR(199),
  kundengruppe             INTEGER,
  kurzbezeichnung          VARCHAR(199),
  name1                    VARCHAR(199),
  name2                    VARCHAR(199),
  strasse_hausnr           VARCHAR(199),
  postleitzahl             VARCHAR(199),
  ort                      VARCHAR(199),
  ansprechpartner          VARCHAR(199),
  vertreternummer          VARCHAR(199),
  telefon                  VARCHAR(199),
  handy                    VARCHAR(199),
  fax                      VARCHAR(199),
  email                    VARCHAR(199),
  laenderkennzeichen       VARCHAR(199),
  sprachkennzeichen        INTEGER, CONSTRAINT sprachkennzeichen CHECK (sprachkennzeichen BETWEEN 0 AND 3),
  preislistenkennzeichen   VARCHAR(199),
  preisgruppe              INTEGER, CONSTRAINT preisgruppe CHECK (preisgruppe BETWEEN 0 AND 99),
  preislistenzwang         BOOL,
  rabatt1                  DECIMAL(10,2),
  rabatt2                  DECIMAL(10,2),
  bankname                 VARCHAR(199),
  bankleitzahl_iban        VARCHAR(199),
  kontonummer              VARCHAR(199),
  einkaufsverband_name     VARCHAR(199),
  einkaufsverband_nummer   VARCHAR(199),
  lieferkonditionen        VARCHAR(199),
  zahlungsart              VARCHAR(199),
  sperrvermerk_bonitaet    INTEGER, CONSTRAINT sperrvermerk_bonitaet CHECK (sperrvermerk_bonitaet BETWEEN 0 AND 2),
  sperrgrund               VARCHAR(199),
  umsatz_gesamt_vorjahr    DECIMAL(10,2),
  umsatz_gesamt_aktjahr    DECIMAL(10,2),
  umsatz_vorjahr_januar    DECIMAL(10,2),
  umsatz_vorjahr_februar   DECIMAL(10,2),
  umsatz_vorjahr_maerz     DECIMAL(10,2),
  umsatz_vorjahr_april     DECIMAL(10,2),
  umsatz_vorjahr_mai       DECIMAL(10,2),
  umsatz_vorjahr_juni      DECIMAL(10,2),
  umsatz_vorjahr_juli      DECIMAL(10,2),
  umsatz_vorjahr_august    DECIMAL(10,2),
  umsatz_vorjahr_september DECIMAL(10,2),
  umsatz_vorjahr_oktober   DECIMAL(10,2),
  umsatz_vorjahr_november  DECIMAL(10,2),
  umsatz_vorjahr_dezember  DECIMAL(10,2),
  umsatz_aktjahr_januar    DECIMAL(10,2),
  umsatz_aktjahr_februar   DECIMAL(10,2),
  umsatz_aktjahr_maerz     DECIMAL(10,2),
  umsatz_aktjahr_april     DECIMAL(10,2),
  umsatz_aktjahr_mai       DECIMAL(10,2),
  umsatz_aktjahr_juni      DECIMAL(10,2),
  umsatz_aktjahr_juli      DECIMAL(10,2),
  umsatz_aktjahr_august    DECIMAL(10,2),
  umsatz_aktjahr_september DECIMAL(10,2),
  umsatz_aktjahr_oktober   DECIMAL(10,2),
  umsatz_aktjahr_november  DECIMAL(10,2),
  umsatz_aktjahr_dezember  DECIMAL(10,2),
  offene_posten            DECIMAL(10,2),
  offene_posten_faellig    DECIMAL(10,2),
  zusatz1                  VARCHAR(199),
  zusatz2                  VARCHAR(199),
  koordinaten              VARCHAR(199),
  kommentare               VARCHAR(500),
  debitorenpreisgruppe     VARCHAR(199),
  debitorenrabattgruppe    VARCHAR(199),
  adresse2                 VARCHAR(199),
  vertretername            VARCHAR(199),
  vertretertelefon         VARCHAR(199),
  kundennummer1            VARCHAR(199),
  kundennummer2            VARCHAR(199),
  kundennummer3            VARCHAR(199),
  kundennummer4            VARCHAR(199),
  kundennummer5            VARCHAR(199),
  kundennummer6            VARCHAR(199),
  kundennummer7            VARCHAR(199),
  kundennummer8            VARCHAR(199),
  kundennummer9            VARCHAR(199),
  kundennummer10           VARCHAR(199),
  kundennummer11           VARCHAR(199),
  kundennummer12           VARCHAR(199),
  kundennummer13           VARCHAR(199),
  kundennummer14           VARCHAR(199),
  kundennummer15           VARCHAR(199),
  kundennummer16           VARCHAR(199),
  kundennummer17           VARCHAR(199),
  kundennummer18           VARCHAR(199),
  kundennummer19           VARCHAR(199),
  kundennummer20           VARCHAR(199),
  last_modified            TIMESTAMP DEFAULT NOW(),

  UNIQUE INDEX customers_kundennummer_index (kundennummer)
);