<!doctype html>

<html>
<head>
    <meta charset="UTF-8"/>
    <style type="text/css">
        html, body {
            margin: 0px;
            width: 100%;
            height: 100%;
            font-size: 12px;
        }

        .fullwidth {
            width: 100%;
        }

        .normalfont {
            font-size: 12px;
        }

        .bold {
            font-weight: bold;
        }

        td {
            padding-top: 3px;
            padding-bottom: 3px;
        }
    </style>
</head>

<body>

<div style="padding: 20px">
    <h1>Auftragsliste - Gruppiert nach Mitarbeiter</h1>

    <h3 style="margin: 0px; padding: 0px">
        Erstellt am ${created_timestamp?datetime?string("dd.MM.yyyy' um 'kk:mm")}
    </h3>
</div>
<#list entries as entry>
<table class="fullwidth normalfont" style="margin-bottom: 32px">
    <colgroup>
        <col style="width: 10%"/>
        <col style="width: 15%"/>
        <col style="width: 15%"/>
        <col style="width: 15%"/>
        <col style="width: 15%"/>
        <col style="width: 15%"/>
        <col style="width: 15%"/>
    </colgroup>
    <tr>
        <td colspan="7">
            <p class="bold">Mitarbeiter: ${entry.employeeNumber}</p>
        </td>
    </tr>
    <tr>
        <td class="bold">Pos.</td>
        <td class="bold">Auftrags-<br/>nummer</td>
        <td class="bold">Datum,<br/>Uhrzeit</td>
        <td class="bold">Mitarbeiter-<br/>nummer</td>
        <td class="bold">Kunden-<br/>nummer</td>
        <td class="bold">Kundenname</td>
        <td class="bold" align="right">Wert</td>
    </tr>
    <tr>
        <td colspan="7" style="background-color: black; height: 1px"></td>
    </tr>
    <#list entry.orders as order>
      <tr>
        <td>${(entry.positionensize[order_index])!'-'}</td>
        <td>${(order.laufnummer?string("0"))!'-'}</td>
        <td>${(order.erfasstAmDatum)!'-'} ${(order.erfasstBisZeit?time?string("kk:mm"))!'-'}</td>
        <td>${(entry.vertreternummern[order_index])!'-'}</td>
        <td>${(order.kundennummer)!'-'}</td>
        <td>${(order.name1?replace('&','u.'))!'-'}</td>
        <td align="right">${(order.sum?string("#0.00€" ))!'-'}</td>
      </tr>
    </#list>
    <tr>
        <td colspan="7" style="background-color: black; height: 1px"></td>
    </tr>
    <tr>
        <td colspan="6" align="right" class="bold">Gesamt:</td>
        <td class="bold" align="right">${(entry.total?string("#0.00€"))!'-'}</td>
    </tr>
</table>
</#list>

<table class="fullwidth normalfont">
    <tr>
        <td align="right"><span class="bold">Gesamtsumme aller Aufträge: ${sum?string("#0.00€")}</span></td>
    </tr>
</table>

</body>
</html>