<!doctype html>

<html>
<head>
    <meta charset="UTF-8"/>
    <style type="text/css">
        html, body {
            margin: 0px;
            width: 100%;
            height: 100%;
            font-size: 12px;
        }

        .fullwidth {
            width: 100%;
        }

        .normalfont {
            font-size: 12px;
        }

        .bold {
            font-weight: bold;
        }

        td {
            padding-top: 3px;
            padding-bottom: 3px;
        }
    </style>
</head>

<body>

<div style="padding: 20px">
    <h1>Auftragsliste - Sortiert nach Auftragswert</h1>

    <h3 style="margin: 0px; padding: 0px">
        Erstellt am ${created_timestamp?datetime?string("dd.MM.yyyy' um 'kk:mm")}
    </h3>
</div>
<table class="fullwidth normalfont" style="margin-bottom: 32px">
    <tr>
        <td class="bold">Rang</td>
        <td class="bold">Auftrags-<br/>nummer</td>
        <td class="bold">Datum,<br/>Uhrzeit</td>
        <td class="bold">Mitarbeiter-<br/>nummer</td>
        <td class="bold">Kunden-<br/>nummer</td>
        <td class="bold">Kundenname</td>
        <td class="bold" align="right">Wert</td>
    </tr>
    <tr>
        <td colspan="7" style="background-color: black; height: 1px"></td>
    </tr>
<#list orders as order>
    <tr>
        <td>${(order_index+1)?string("0")}</td>
        <td>${(order.laufnummer?string("0"))!"-"}</td>
        <td>${(order.erfasstAmDatum)!'-'} ${(order.erfasstBisZeit?time?string("kk:mm"))!'-'}</td>
        <td>${(vertreternummern[order_index])!'-'}</td>
        <td>${(order.kundennummer)!'-'}</td>
        <td>${(order.name1?replace('&','u.'))!'-'}</td>
        <td align="right">${order.sum?string("#0.00€")!'-1'}</td>
    </tr>
</#list>
    <tr>
        <td colspan="7" style="background-color: black; height: 1px"></td>
    </tr>
    <tr>
        <td colspan="7" align="right">
            <span class="bold">Gesamtsumme: ${sum?string("#0.00€")}</span>
        </td>
    </tr>
    <tr>
        <td colspan="7" align="right">
            <span class="bold">Rabatte: ${totalDicount?string("#0.00€")}</span>
        </td>
    </tr>
    <tr>
        <td colspan="7" align="right">
            <span class="bold">Gesamtsumme (Rabatt berücksichtigt): ${sumWithDiscount?string("#0.00€")}</span>
        </td>
    </tr>
</table>
</body>
</html>