<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
    <title>IngeGlas Bestellbestätigung</title>
    <meta charset="UTF-8"/>
    <style type="text/css">
        html, body {
            margin: 0px;
            width: 100%;
            height: 100%;
            font-size: 12px;
        }

        #logo {
        }

        .fullwidth {
            width: 100%;
        }

        .normaltext {
            font-size: 12px;
        }

        .largetext {
            font-size: 14px;
        }

        td {
            padding-top: 6px;
            padding-bottom: 3px;
        }

        .pagebreak {
            page-break-after: always;
        }
    </style>
</head>
<body>
<table class="fullwidth normaltext">
    <tr>
        <td colspan="2" align="right">
            <img src="logo.jpg" id="logo" alt="Logo" width="350px"/>
        </td>
    </tr>
    <tr>
        <td width="60%">
            <p style="text-align: left; margin-left: 30px; height: 100%" class="largetext">
            <#if customer?has_content>
            ${(customer.name1)!'-'}<br/>
            ${(customer.name2)!'-'}<br/>
            ${(customer.strasseHausnr)!'-'}<br/>
                <#if customer?has_content && customer.laenderkennzeichen?has_content>
                ${customer.laenderkennzeichen}
                </#if>
            ${(customer.postleitzahl)!'-'} ${(customer.ort)!'-'}<br/>
            <#else>
            ${(order.name1)!'-'}<br/>
            ${(order.name2)!'-'}<br/>
            ${(order.strasse)!'-'}<br/>
            ${(order.plz)!'-'} ${(order.ort)!'-'}<br/>
            </#if>
            </p>
        </td>
        <td width="40%">
            <p>
                Inge's Christmas Decor GmbH<br/>
                Dieselstraße 7<br/>
                96465 Neustadt b. Coburg<br/>
                GERMANY<br/>
            </p>

            <p>
                Telefon: +49 9568/857-0<br/>
                Fax: +49 9568/857-57<br/>
                email: info@inge-glas.de<br/>
                www.inge-glas.de<br/>
            </p>
        </td>
    </tr>
    <tr>
        <td>
            <p>
                <span style="font-size: 20px">Bestell-Nr. ${order.laufnummer?string("0")}</span><br/>
                <span>Kundennummer:
                <#if neukunde>
                    - (Neuer Kunde)
                <#else>
                ${customer.kundennummer}
                </#if>
                </span>
            </p>
        </td>
        <td>
            <p>
                Mitarbeiter:
            <#if order.mitarbeiternummer?has_content>
            ${order.mitarbeiternummer}
                <#if employee??>
                    (${employee.personalDetails.firstname!'-'} ${employee.personalDetails.surname!'-'})
                </#if>
            <#else>
                Keine Angabe
            </#if>
                <br/>
                Datum: ${order.erfasstAmDatum!'-'}<br/>
                Lieferung ab:
            <#if order.lieferKw?has_content>
                KW ${order.lieferKw!'-'}
            <#else>
                Keine Angabe
            </#if>
                <br/>
            </p>
        </td>
    </tr>
</table>

<table class="fullwidth normaltext" style="border-collapse: collapse; margin-top: 20px">
    <tr class="largetext">
        <td width="10%">Pos.</td>
        <td width="20%">Artikelnummer</td>
        <td width="35%">Bezeichnung</td>
        <td width="10%">Menge</td>
        <td width="15%" align="right">Einzelpreis</td>
        <td width="10%" align="right">Gesamt</td>
    </tr>

    <tr>
        <!-- Workaround: PDF Export exportiert border-bottom nicht korrekt -->
        <td colspan="6" style="background-color: black; height: 1px; padding: 0px; margin: 0px"></td>
    </tr>
<#if order.belegtext??>
    <tr>
        <td colspan="5">
            <p>
            ${order.belegtext}
            </p>
        </td>
    </tr>
</#if>

    <!-- Positionen -->
<#list positionen as position>
    <tr>
        <td valign="top">${(position_index + 1)?string("0")}</td>
        <td valign="top">${position.artikelnummer}</td>
        <td valign="top" style="padding-right: 10px">
            <#if artikelbezeichnungen[position.artikelnummer]?has_content>
            ${artikelbezeichnungen[position.artikelnummer]}
            <#else>
                -
            </#if>
            <#if position.positionstext?has_content>
                <br/> ${position.positionstext}
            </#if>
        </td>
        <td valign="top">${position.menge}</td>
        <td valign="top" align="right">${position.einzelpreis} €</td>
        <td valign="top" align="right">${position.preis} €</td>
    </tr>
    <!--
    30
    70
    110
    130
    …
    -->
    <#if (position_index+1 == 30) || ((position_index > 60) && (((position_index+1-30) % 40) == 0))>
        <tr>
            <!-- Workaround: PDF Export exportiert border-bottom nicht korrekt -->
            <td colspan="6" style="background-color: black; height: 1px; padding: 0px; margin: 0px"></td>
        </tr>
        <tr>
            <td colspan="6" align="right" class="largetext">
                Zwischensumme: ${sums["index_" + (position_index+1)?c]} €
            </td>
        </tr>
        <p class="pagebreak"/>

        <tr style="padding-bottom: 10px">
            <td colspan="3" align="left" class="largetext">
                <p style="margin-bottom: 14px">
                    BESTELLUNG ${order.laufnummer?string("#")} von Kunde ${customer.kundennummer}
                </p>
            </td>
            <td colspan="3" align="right" class="normaltext">
                <p style="margin-bottom: 14px">
                    Seite ${(((position_index+1)/30) + 1)?string("0")}
                </p>
            </td>
        </tr>

        <tr class="largetext">
            <td>Pos.</td>
            <td>Artikelnummer</td>
            <td>Bezeichnung</td>
            <td>Menge</td>
            <td align="right">Einzelpreis</td>
            <td align="right">Gesamt</td>
        </tr>

        <tr>
            <!-- Workaround: PDF Export exportiert border-bottom nicht korrekt -->
            <td colspan="6" style="background-color: black; height: 1px; padding: 0px; margin: 0px"></td>
        </tr>
    </#if>
</#list>
    <tr>
        <!-- Workaround: PDF Export exportiert border-bottom nicht korrekt -->
        <td colspan="6" style="background-color: black; height: 1px; padding: 0px; margin: 0px"></td>
    </tr>
    <tr>
        <td colspan="6" align="right" class="largetext">
            Gesamtsumme: <span style="font-weight: bold; text-decoration: underline">${sum} €</span>
        </td>
    </tr>
</table>

<p>
    Wir danken Ihnen für Ihre Bestellung.<br/>
    Unsere verbindliche Auftragsbestätigung folgt in Kürze.
</p>


<div style="width: 20%;margin-left: 10%">
<#if sigfile?has_content>
    <img src="${sigfile}" id="signatur" alt="Signatur" style="margin-bottom: 8px"/>
<#else>
    <p style="padding-top: 80px">&nbsp;</p>
</#if>
    <div style="height: 1px; width: 100%; background-color: black"></div>
    Unterschrift
</div>

</body>
</html>