<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
  <title>Bestellbestätigung</title>
  <meta charset="UTF-8"/>
  <style type="text/css">
    html, body {
      margin: 0px;
      width: 100%;
      height: 100%;
      font-size: 12px;
    }

    #logo {
    }

    .fullwidth {
      width: 100%;
    }

    .normaltext {
      font-size: 12px;
    }

    .largetext {
      font-size: 14px;
    }

    td {
      padding-top: 6px;
      padding-bottom: 3px;
    }

    .pagebreak {
      page-break-after: always;
    }

    .boldunderline {
      font-weight: bold;
      text-decoration: underline;
    }

    .artikelbild {
      width: 30px;
      height: 30px;
    }
  </style>
</head>
<body>
<div style="height: 170px"></div>
<table class="fullwidth normaltext">
  <tr>
    <td>&nbsp;</td>
    <td>
      <h2 style="margin-bottom: 1.5em">BESTELLBESTÄTIGUNG</h2>
    </td>
  </tr>
  <tr>
    <td width="60%">
      <p style="text-align: left; padding-bottom: 20px; margin-left: 30px; height: 100%" class="largetext">
      <#if customer??>
      ${(customer.name1)!'-'}<br/>
      ${(customer.name2)!'-'}<br/>
      ${(customer.strasseHausnr)!'-'}<br/>
      ${customer.laenderkennzeichen!'-'}
      ${(customer.postleitzahl)!'-'} ${(customer.ort)!'-'}<br/>
      <#else>
      ${(order.name1)!'-'}<br/>
      ${(order.name2)!'-'}<br/>
      ${(order.strasse)!'-'}<br/>
      ${(order.plz)!'-'} ${(order.ort)!'-'}<br/>
      </#if>
      </p>
    </td>
    <td width="40%" valign="top">
      <p>
        Mitarbeiter:
      <#if order.mitarbeiternummer?has_content>
      ${order.mitarbeiternummer}
          <#if employee??>
            (${employee.personalDetails.firstname!'-'} ${employee.personalDetails.surname!'-'})
          </#if>
      <#else>
        Keine Angabe
      </#if>
        <br/>
        Auftragsdatum: ${order.erfasstAmDatum!'-'}<br/>
        Kundennummer:
      <#if order.kundennummer?has_content>
      ${order.kundennummer!'-'}
      <#else>
        Keine Angabe
      </#if>
        <br/>
        Lieferdatum:
      <#if order.lieferdatum?has_content && order.lieferKw?has_content>
      ${order.lieferdatum!'-'} (KW ${order.lieferKw!'-'})
      <#elseif order.lieferdatum?has_content>
      ${order.lieferdatum!'-'}
      <#elseif order.lieferKw?has_content>
        KW ${order.lieferKw!'-'}
      <#else>
        Keine Angabe
      </#if>
          <br/>
      <#if valutaDatum?has_content>
          Valuta Datum: ${valutaDatum!'-'}
      <#elseif valutaTage?has_content>
          Valuta Tage: ${valutaTage!'-'}
      <#else>
      </#if>

        <br/>
      </p>
    </td>
  </tr>
  <tr>
    <td colspan="2">
      <p>
        <span style="font-size: 20px">Bestell-Nr. ${order.laufnummer?string("0")}</span><br/>
        <span>Kundennummer:
        <#if neukunde>
          - (Neuer Kunde)
        <#else>
            <#if customer??>
            ${customer.kundennummer}
            <#else>
              -
            </#if>
        </#if>
                </span>
      </p>
    </td>
  </tr>
</table>

<table class="fullwidth normaltext" style="border-collapse: collapse; margin-top: 20px">
  <tr class="largetext">
    <td width="8%">Pos.</td>
    <td width="15%"></td>
    <td width="10%">Artikel Nr.</td>
  <#if displayve>
    <td width="7%">VE</td>
  <#else>
    <td width="0%"></td>
  </#if>
    <td width="*">Bezeichnung</td>
    <td width="10%" align="right">Menge</td>
    <td width="15%" align="right">Einzelpreis</td>
  <#if showdiscountscolumn>
    <td width="7%" align="right">
      Rabatt
    </td>
  <#else>
    <td width="0%"></td>
  </#if>

    <td width="10%" align="right">Gesamt</td>
  </tr>

  <tr>
    <!-- Workaround: PDF Export exportiert border-bottom nicht korrekt -->
    <td colspan="9" style="background-color: black; height: 1px; padding: 0px; margin: 0px"></td>
  </tr>
<#if order.belegtext??>
  <tr>
    <td colspan="9">
      <p>
      ${order.belegtext}
      </p>
    </td>
  </tr>
</#if>

<#list positionen as position>
  <tr height="46px">
    <td valign="top">${(position_index + 1)?string("0")}</td>
    <td valign="top"><div style="width: 150px; height: 150px; overflow: hidden;"><img src="${mediaPath}/${artikelBilder[position.artikelnummer]}" id="artikelbild" alt="Artikelbild" width="30px" height="30px" style="margin-bottom: 8px"/></div></td>
    <td valign="top">${position.artikelnummer}</td>
    <td valign="top">
        <#if displayve>
            <#if verpackungseinheiten[position.artikelnummer]?has_content>
        ${verpackungseinheiten[position.artikelnummer]}
        </#if>
            </#if>
    </td>
    <td valign="top" style="padding-right: 10px">
        <#if artikelbezeichnungen[position.artikelnummer]?has_content>
        ${artikelbezeichnungen[position.artikelnummer]}
        <#else>
          &nbsp;
        </#if>
    </td>
    <td valign="top" align="right">${position.menge}</td>
    <td valign="top" align="right">${position.einzelpreis?replace(".", ",")} <#if disableCurrency><#else>€</#if><#if position.manuellerEinzelpreis?has_content>*<#else></#if></td>
    <td valign="top" align="right">
        <#if showdiscountscolumn>
        ${positionsdiscounts[position.artikelnummer]}%
        </#if></td>
    <td valign="top" align="right">${position.preis} <#if disableCurrency><#else>€</#if></td>
  </tr>

    <#if (position_index+1 == 10) || ((position_index > 15) && (((position_index-10) % 15) == 0))>
      <tr>
        <!-- Workaround: PDF Export exportiert border-bottom nicht korrekt -->
        <td colspan="9" style="background-color: black; height: 1px; padding: 0px; margin: 0px"></td>
      </tr>
      <tr>
        <td colspan="9" align="right" class="largetext">
          Zwischensumme: ${sums["index_" + (position_index+1)?c]} <#if disableCurrency><#else>€</#if>
        </td>
      </tr>
      <p class="pagebreak"/>

      <div style="height: 170px"></div>

      <tr style="padding-bottom: 10px">
        <td colspan="4" align="left" class="largetext">
          <p style="margin-bottom: 14px">
            BESTELLUNG ${order.laufnummer?string("#")} von Kunde
              <#if customer??>
              ${customer.kundennummer}
              <#else>
                -
              </#if>
          </p>
        </td>
        <td colspan="2" align="right" class="normaltext">
          <p style="margin-bottom: 14px">
              <#if ((position_index+1)%15 == 0) && ((position_index+1) > 10)>
                Seite ${(((position_index+1)/15)?floor + 0)?string("0")}
              <#else>
                Seite ${(((position_index+1)/10)?floor + 1)?string("0")}
              </#if>
          </p>
        </td>
      </tr>

      <tr class="largetext">

        <td width="8%">Pos.</td>
        <td width="15%"></td>
        <td width="10%">Artikel Nr.</td>
          <#if displayve>
            <td width="7%">VE</td>
          <#else>
            <td width="0%"></td>
          </#if>
        <td width="*">Bezeichnung</td>
        <td width="10%" align="right">Menge</td>
        <td width="15%" align="right">Einzelpreis</td>
          <#if showdiscountscolumn>
            <td width="7%" align="right">
              Rabatt
            </td>
          <#else>
            <td width="0%"></td>
          </#if>

        <td width="10%" align="right">Gesamt</td>
      </tr>

      <tr>
        <!-- Workaround: PDF Export exportiert border-bottom nicht korrekt -->
        <td colspan="8" style="background-color: black; height: 1px; padding: 0px; margin: 0px"></td>
      </tr>
    </#if>
</#list>
  <tr>
    <!-- Workaround: PDF Export exportiert border-bottom nicht korrekt -->
    <td colspan="9" style="background-color: black; height: 1px; padding: 0px; margin: 0px"></td>
  </tr>
  <tr>
    <td colspan="8" align="right" class="largetext">
      Summe:
    </td>
    <td class="boldunderline" align="right">
    ${sum} <#if disableCurrency><#else>€</#if>
    </td>
  </tr>
<#if auftragsrabatt?has_content>
  <tr>
    <td colspan="7" align="right" class="largetext">
        Rabatt <#if order.belegrabatt?has_content>(${auftragsrabattInProzent}%)<#else></#if>:
    </td>
    <td align="right">
    ${auftragsrabatt} <#if disableCurrency><#else>€</#if>
    </td>
  </tr>
  <tr>
    <td colspan="7" align="right" class="largetext">
      Gesamt:
    </td>
    <td align="right">
    ${gesamtsumme} <#if disableCurrency><#else>€</#if>
    </td>
  </tr>
</#if>
</table>

<#if fusstext?has_content>
<p>
${fusstext}
</p>
</#if>

<#if disableSignature><#else>
<div style="width: 20%;margin-left: 10%">
  <#if sigfile?has_content>
      <img src="${sigfile}" id="signatur" alt="Signatur" style="margin-bottom: 8px"/>
  <#else>
      <p style="padding-top: 80px">&nbsp;</p>
  </#if>
    <div style="height: 1px; width: 100%; background-color: black"></div>
    Unterschrift
</div>
</#if>

</body>
</html>